/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits.abilities;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.traits.AbilityHandler;
import xzeroair.trinkets.traits.abilities.Ability;
import xzeroair.trinkets.traits.abilities.interfaces.IAttackAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IPotionAbility;
import xzeroair.trinkets.traits.abilities.interfaces.ITickableAbility;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.compat.lycanitesmobs.LycanitesCompat;

public class AbilityFireImmunity
extends Ability
implements ITickableAbility,
IPotionAbility,
IAttackAbility {
    protected int amplifier = 0;

    public AbilityFireImmunity() {
        super("fire_immunity");
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public AbilityFireImmunity setAmplifier(int amp) {
        if (this.amplifier != amp) {
            this.amplifier = amp;
        }
        return this;
    }

    @Override
    public void tickAbility(EntityLivingBase entity) {
        AbilityHandler.AbilityHolder holder;
        if (entity.func_70027_ad()) {
            entity.func_70066_B();
        }
        int amp = this.getAmplifier();
        if (Trinkets.FireResistanceTiers && (holder = this.getAbilityHolder()) != null) {
            if (holder.getSourceID().equalsIgnoreCase("xat:dragons_eye")) {
                amp = TrinketsConfig.SERVER.Items.DRAGON_EYE.compat.FRTiers.amplifier;
            } else if (holder.getSourceID().equalsIgnoreCase("xat:dragon")) {
                amp = TrinketsConfig.SERVER.races.dragon.compat.FRTiers.amplifier;
            }
        }
        PotionEffect fireResist = new PotionEffect(MobEffects.field_76426_n, 3600, amp, false, false);
        entity.func_70690_d(fireResist);
        if (entity.func_70644_a(MobEffects.field_76426_n) && entity.field_70170_p.field_72995_K) {
            entity.func_70660_b(MobEffects.field_76426_n).func_100012_b(true);
        }
    }

    @Override
    public void onAbilityRemoved(EntityLivingBase entity) {
        if (entity.func_70644_a(MobEffects.field_76426_n)) {
            entity.func_184589_d(MobEffects.field_76426_n);
        }
    }

    @Override
    public boolean potionApplied(EntityLivingBase entity, PotionEffect effect, boolean cancel) {
        String e = effect.func_188419_a().getRegistryName().toString();
        Potion smouldering = LycanitesCompat.getPotionEffectByName("smouldering");
        if (smouldering != null && e.contentEquals(smouldering.getRegistryName().toString())) {
            return true;
        }
        return cancel;
    }

    @Override
    public boolean attacked(EntityLivingBase attacked, DamageSource damage, float dmg, boolean cancel) {
        if (damage.func_76347_k()) {
            return true;
        }
        return cancel;
    }

    @Override
    public float damaged(EntityLivingBase attacked, DamageSource source, float dmg) {
        if (Trinkets.FireResistanceTiers) {
            return dmg;
        }
        if (source.func_76347_k()) {
            return 0.0f;
        }
        return dmg;
    }
}

